/*
 * Decompiled with CFR 0.152.
 */
package emulator.assembler;

import emulator.assembler.DataDescription;
import emulator.assembler.Instruction;
import java.util.HashMap;
import java.util.TreeMap;

public class DataDescriptionTable {
    private HashMap<Integer, Integer> address_to_index = new HashMap();
    private HashMap<Integer, Integer> index_to_address = new HashMap();
    private TreeMap<Integer, DataDescription> description_map = new TreeMap();

    public DataDescriptionTable(int address_min, int address_max, int initial_granularity) {
        int position = 0;
        int i = address_min;
        while (i <= address_max) {
            this.description_map.put(i, new DataDescription(i, initial_granularity));
            this.address_to_index.put(i, position);
            this.index_to_address.put(position, i);
            ++position;
            i += initial_granularity;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataDescriptionTable(DataDescriptionTable source) {
        this.description_map.clear();
        DataDescriptionTable dataDescriptionTable = source;
        synchronized (dataDescriptionTable) {
            for (DataDescription data : source.description_map.values()) {
                this.description_map.put(data.getAddress(), data);
            }
        }
        this.reindex();
    }

    public synchronized void reindex() {
        this.address_to_index.clear();
        this.index_to_address.clear();
        int position = 0;
        for (Integer address : this.description_map.keySet()) {
            this.address_to_index.put(address, position);
            this.index_to_address.put(position, address);
            ++position;
        }
    }

    public synchronized DataDescription getDescriptionForAddress(int address) {
        return this.description_map.floorEntry(address).getValue();
    }

    public synchronized DataDescription getDescriptionForIndex(int index) {
        Integer address = this.index_to_address.get(index);
        return address == null ? null : this.description_map.get(address);
    }

    public synchronized int size() {
        return this.description_map.size();
    }

    public synchronized int getIndexForAddress(int address) {
        int key_address = this.description_map.floorKey(address);
        return this.address_to_index.get(key_address);
    }

    public synchronized void insertInstruction(int address, Instruction instruction) {
        DataDescription description = this.getDescriptionForAddress(address);
        if (description.getAddress() < address) {
            int prefix = address - description.getAddress();
            int block_end = instruction.getByteCount() + prefix;
            while (description.getLength() < block_end) {
                this.growEntry(description);
            }
            this.splitEntry(description, prefix);
        }
        int block_size = instruction.getByteCount();
        while (description.getLength() < block_size) {
            this.growEntry(description);
        }
        if (description.getLength() == block_size) {
            description.setIsCode(true);
        } else {
            this.shiftEntryBegin(description, block_size);
            this.insertCodeBlock(address, block_size);
        }
    }

    public void splitEntry(DataDescription description, int prefix) {
        DataDescription description2 = new DataDescription(description.getAddress(), prefix);
        description2.setIsCode(description.isCode());
        this.shiftEntryBegin(description, prefix);
        this.description_map.put(description2.getAddress(), description2);
    }

    public void growEntry(DataDescription description) {
        DataDescription next = this.description_map.higherEntry(description.getAddress()).getValue();
        this.description_map.remove(next.getAddress());
        description.setLength(description.getLength() + next.getLength());
    }

    public void insertCodeBlock(int address, int block_size) {
        DataDescription new_data = new DataDescription(address, block_size);
        new_data.setIsCode(true);
        this.description_map.put(address, new_data);
    }

    public void shiftEntryBegin(DataDescription description, int front_reduce) {
        this.description_map.remove(description.getAddress());
        description.setAddress(description.getAddress() + front_reduce);
        description.setLength(description.getLength() - front_reduce);
        this.description_map.put(description.getAddress(), description);
    }
}

